uniform mat4 v_mvpMatrix;
uniform vec3 v_lightPos;

attribute vec3 v_position;
attribute vec3 v_normal;
attribute vec4 v_color;
attribute vec2 v_texCoord;

varying vec3 p_lightVec; 
varying vec3 p_normal;

varying vec4 p_color;
varying vec2 p_textureCoord;

void main()
{
    mediump vec4 read_pos;
    read_pos.xyz = v_position;
    read_pos.a = 1.0;
    gl_Position = v_mvpMatrix * read_pos;
    p_color = v_color;
    p_textureCoord = v_texCoord;
    p_normal = v_normal;
    
    p_lightVec = normalize(v_lightPos - v_position);
}

